{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author     PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2020 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<script>
    var jsTranslations = {
        "moreDetails": "{l s='More details' mod='colissimo'}",
        "lessDetails": "{l s='Less details' mod='colissimo'}",
        "relay": "{l s='Relay' mod='colissimo'}",
        "postOffice": "{l s='Post office' mod='colissimo'}",
        "closed": "{l s='Closed' mod='colissimo'}",
        "openingHours": "{l s='Opening hours' mod='colissimo'}",
        "monday": "{l s='Monday' mod='colissimo'}",
        "tuesday": "{l s='Tuesday' mod='colissimo'}",
        "wednesday": "{l s='Wednesday' mod='colissimo'}",
        "thursday": "{l s='Thursday' mod='colissimo'}",
        "friday": "{l s='Friday' mod='colissimo'}",
        "saturday": "{l s='Saturday' mod='colissimo'}",
        "sunday": "{l s='Sunday' mod='colissimo'}",
        "select": "{l s='Select' mod='colissimo'}",
        "accessibility": "{l s='Accessibility' mod='colissimo'}",
        "parking": "{l s='Parking' mod='colissimo'}",
        "disabledAccess": "{l s='Disabled access' mod='colissimo'}",
        "after7pm": "{l s='After 7pm' mod='colissimo'}",
    };
    if (typeof colissimoAjaxWidget === 'undefined') {
        var colissimoAjaxWidget = baseDir;
    }
    $(document).on('change', '.address_select', function(){
        setTimeout(function () {
            window.location.hash = '#opc_delivery_methods';
            window.location.reload(true);
        }, 1000);
    });
</script>
{if isset($colissimo_service)}
    {if isset($colissimo_customs_fees)}
        {if isset($check_ddp) && $serviceType == 'SANS_SIGNATURE'}
        {else}
            <div class="customs-fees" style="display:none">
                <p class="alert alert-warning delivery-duty-paid">
                    <strong>{l s='Delivery includes %s %s customs fees'  sprintf=[$colissimo_customs_fees, $currency] mod='colissimo'}</strong>
                </p>
            </div>
        {/if}
    {/if}
    {if $colissimo_service == "RELAIS"}
        <script type="text/javascript">
            var colissimoToken = '{$colissimo_widget_token|escape:'htmlall':'UTF-8'}';
            var colissimoPreparationTime = {$preparation_time|intval};
            var widgetLang = "{$colissimo_widget_lang|escape:'htmlall':'UTF-8'}";
            var mobilePhone = "{$mobile_phone|escape:'htmlall':'UTF-8'}";
            var colissimoDeliveryAddress = {
                address: '{$delivery_addr.address|strip_tags|addslashes nofilter}',
                zipcode: '{$delivery_addr.zipcode|escape:'htmlall':'UTF-8'}',
                city: '{$delivery_addr.city|strip_tags|addslashes nofilter}',
                isoCountry: '{$delivery_addr.iso_country|escape:'htmlall':'UTF-8'}'
            };
            {if isset($widget_native_mobile)}
            var widgetNativeMobile = {$widget_native_mobile|intval};
            var couleur1Mobile = '{$widget_color_1_mobile|escape:'htmlall':'UTF-8'}';
            var couleur2Mobile = '{$widget_color_2_mobile|escape:'htmlall':'UTF-8'}';
            var policeMobile = '{$widget_police_mobile|escape:'htmlall':'UTF-8'}';
            {else}
            var widgetOSMMobile = {$widget_osm_mobile|intval};
            var widgetInModalMobile = {$widget_osm_in_modal_mobile|intval};
            var widgetMaxPointMobile = {$widget_osm_max_point_mobile|intval};
            var widgetOMSDisplayMapMobile = {$widget_osm_display_map_mobile|intval};
            var widgetOSMDisplaySuperposed = {$widget_osm_display_superposed|intval};
            {/if}
            $(document).on('change', 'input.delivery_option_radio', function () {
                $('.colissimo-pickup-point-address').css('display', 'none');
                $('#HOOK_PAYMENT').show();
            });
            $(document).ready(function () {
                {if isset($widget_osm_mobile) && isset($widget_osm_in_modal_mobile)}
                if (widgetInModalMobile == 0) {
                    if (typeof $('#colissimo-select-pickup-point') !== undefined) {
                        $('#colissimo-select-pickup-point').click();
                    }
                }
                {/if}
                var delivery_option_checked = $('input.delivery_option_radio:checked');
                var delivery_option = delivery_option_checked.closest('.delivery_option');
                if ($('.colissimo-pickup-point-address').length > 0) {
                    var colissimo_widget = $(".pickup-point").html();
                    $(".pickup-point").empty();
                    $(colissimo_widget).insertAfter(delivery_option);
                }
                if (!jQuery('body > .colissimo-front-widget').length) {
                    jQuery('.colissimo-front-widget').appendTo('body');
                } else {
                    jQuery('.hook_extracarrier > .colissimo-front-widget').remove();
                }
                initMobileField();
            });
        </script>
        {if isset($widget_osm_type_point_mobile)}
            <input type="hidden" id="typeOfPointMobile" value='{$widget_osm_type_point_mobile|escape:'htmlall':'UTF-8'}'/>
        {/if}
        {if isset($widget_native_mobile)}
            <div class="colissimo-front-widget modal fade" style="display:none;">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div id="colissimo-widget-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        {/if}
        <div class="colissimo-pickup-point-address">
            {include file="./_partials/pickup-point-address.tpl"}
        </div>
        {if isset($widget_osm_mobile)}
            {include file="./_partials/widget-osm-mobile.tpl"}
        {/if}
    {else}
        <script type="text/javascript">
            var colissimoDeliveryAddressDDP = {
                address: '{$delivery_addr.address|strip_tags|addslashes nofilter}',
                zipcode: '{$delivery_addr.zipcode|escape:'htmlall':'UTF-8'}',
                city: '{$delivery_addr.city|strip_tags|addslashes nofilter}',
                isoCountry: '{$delivery_addr.iso_country|escape:'htmlall':'UTF-8'}'
            };
            $(document).on('change', 'input.delivery_option_radio', function () {
                $('.colissimo-address-fields').css('display', 'none');
                $('.delivery-duty-paid').css('display', 'none');
                $('.colissimo-tel-field').css('display', 'none');
            });
            $(document).ready(function () {
                var delivery_option_checked = $('input.delivery_option_radio:checked');
                var delivery_option = delivery_option_checked.closest('.delivery_option');
                if ($('.colissimo-address-fields').length > 0) {
                    var colissimo_address = $(".colissimo-address").html();
                    $(".colissimo-address").empty();
                    $(colissimo_address).insertAfter(delivery_option);
                }
                if ($('.colissimo-tel-field').length > 0) {
                    var tel = $(".colissimo-tel-field").html();
                    $(".content-ddp-tel").empty();
                    $(tel).insertAfter(delivery_option);
                }
                if ($('.delivery-duty-paid').length > 0) {
                    var colissimo_ddp = $(".customs-fees").html();
                    $(".colissimo_ddp").empty();
                    $(colissimo_ddp).insertAfter(delivery_option);
                }
                initMobileFieldDDP();
            });
        </script>
        <div class="colissimo-address">
            <div class="colissimo-address-fields" {if !$display_door_codes}style="display:none;"{/if}>
                {include file="./_partials/address-fields.tpl"}
            </div>
        </div>
        {if (isset($colissimo_ddp) && $colissimo_ddp)}
            <div class="colissimo-tel-field">
                {include file="./_partials/inputTel.tpl"}
            </div>
        {/if}
    {/if}
{/if}
