/*
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2020 PrestaShop SA
 *  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */


var itiddp;

function initMobileFieldDDP() {
    $(".colissimo-mobile-phone").each(function (index, inputtel) {
        // var itiddp;
        var elm = $(this);
        var allowDropDown;
        var isoDelivery;
        if (typeof colissimoDeliveryAddressDDP === 'undefined') {
            return
        }
        isoDelivery = colissimoDeliveryAddressDDP['isoCountry'];
        if (isoDelivery == 'MC') {
            isoDelivery = 'FR';
        }
        if (isoDelivery == 'BE') {
            onlyCountries = ['BE'];
            allowDropDown = false;
        } else {
            onlyCountries = [];
            allowDropDown = true;
        }
        if (inputtel !== null) {
            itiddp = window.intlTelInput(inputtel, {
                utilsScript: colissimoAjaxWidget + 'modules/colissimo/views/js/utils.js',
                initialCountry: isoDelivery,
                nationalMode: true,
                separateDialCode: true,
                hiddenInput: 'full',
                preferredCountries: [],
                onlyCountries: onlyCountries,
                allowDropdown: allowDropDown,
                customPlaceholder: typeof fctCustomPlaceholder === 'function' ? function (selectedCountryPlaceholder, selectedCountryData) {
                    return fctCustomPlaceholder(selectedCountryPlaceholder, selectedCountryData)
                } : '',
            });
            var handleChangeTel = function () {
                if (itiddp.isValidNumber()) {
                    jQuery('.js-colissimo-mobile-valid').show();
                    jQuery('.js-colissimo-mobile-invalid').hide();
                    jQuery('.js-colissimo-is-mobile-valid').val('1');
                } else {
                    jQuery('.js-colissimo-mobile-valid').hide();
                    jQuery('.js-colissimo-mobile-invalid').show();
                    jQuery('.js-colissimo-is-mobile-valid').val('0');
                }
                $('.colissimo-mobile-phone').val(elm.val());
            };
            inputtel.addEventListener('change', handleChangeTel);
            inputtel.addEventListener('keyup', handleChangeTel);
            inputtel.addEventListener('countrychange', function () {
                handleChangeTel();
            });
            itiddp.promise.then(function () {
                handleChangeTel();
            });

            return itiddp;
        }
    });
};

jQuery(document).on('click', '#colissimo-opc-phone-validation-ddp', function () {

    var mobilePhoneSave = itiddp.getNumber();
    var isMobileValid = itiddp.isValidNumber();
    var btnValidation = jQuery('.colissimo-opc-phone-validation-ddp');
    var result = jQuery('.js-colissimo-mobile-validation');
    var iso = colissimoDeliveryAddressDDP['isoCountry'];
    if (mobilePhoneSave === undefined) {
        mobilePhoneSave = '';
    }
    btnValidation.find('i').removeClass('icon-check').addClass('icon-spinner icon-spin');
    result.removeClass('colissimo-mobile-validation-success').removeClass('colissimo-mobile-validation-error').text('');

    jQuery.ajax({
        type: 'POST',
        dataType: 'json',
        url: colissimoAjaxWidget + 'index.php',
        data: {
            fc: 'module',
            module: 'colissimo',
            controller: 'widget',
            ajax: 1,
            action: 'saveDDPMobilePhoneOpc',
            mobilePhone: mobilePhoneSave,
            isMobileValid: isMobileValid ? 1 : 0,
        }
    }).fail(function (jqXHR, textStatus) {
    }).done(function (data) {
        result.text(data.text_result);
        if (!data.errors) {
            result.addClass('colissimo-mobile-validation-success');
            if (jQuery('#cgv').prop('checked') === true) {
                jQuery('#HOOK_PAYMENT').show();
            }
        } else {
            result.addClass('colissimo-mobile-validation-error');
            jQuery('#HOOK_PAYMENT').hide();
        }
    }).always(function (data) {
        btnValidation.find('i').addClass('icon-check').removeClass('icon-spinner icon-spin');
    });

});