<?php
/**
 * 2022-2025 PhenixSuite©
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@phenixsuite.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PhenixSuite to newer
 * versions in the future. If you wish to customize PhenixSuite for your
 * needs please refer to https://phenixsuite.com for more information.
 *
 *  @author    PhenixSuite <contact@phenixsuite.com>
 *  @copyright 2022-2025 PhenixSuite
 *  @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Upgrade to 19
 *
 * @param $module Colissimo
 * @return bool
 */
function upgrade_module_19($module)
{
    $logsEnabled = Configuration::get('COLISSIMO_LOGS');
    Configuration::updateValue('COLISSIMO_LOGS', 1);
    $module->initLogger();
    $module->logger->setChannel('ModuleUpgrade');
    $module->logger->info('Module upgrade. Version 19');

    Configuration::updateValue('COLISSIMO_WIDGET_ENDPOINT', 'https://ws.colissimo.fr/widget-point-retrait/rest/authenticate.rest');
    Configuration::updateValue('COLISSIMO_WIDGET_ENDPOINT_MOBILE', 'https://ws.colissimo.fr/widget-point-retrait/rest/authenticate.rest');

    $module->logger->info('Module upgraded.');
    Configuration::updateValue('COLISSIMO_LOGS', (int)$logsEnabled);

    return true;
}
