<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class ColissimoSignatureInformationsResponse
 */
class ColissimoSignatureInformationsResponse extends AbstractColissimoResponse implements ColissimoReturnedResponseInterface
{
    /** @var string */
    public $cgv;

    /** @var string */
    public $contractType;

    /**
     * @param mixed $responseHeader
     * @param mixed $responseBody
     * @return ColissimoCGVInformationsResponse
     */
    public static function buildFromResponse($responseHeader, $responseBody)
    {
        $informationsCGVResponse = new self();
        $responseArray = json_decode($responseBody, true);
        if (!empty($responseArray)) {
            $informationsCGVResponse->cgv = $responseArray['cgv']['accepted'];
            $informationsCGVResponse->contractType = $responseArray['contractType'];
        }

        return $informationsCGVResponse;
    }
}
