<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class ColissimoGenerateLabelResponse
 */
class ColissimoGenerateLabelResponse extends AbstractColissimoResponse implements ColissimoReturnedResponseInterface
{
    /** @var string */
    public $label;

    /** @var string */
    public $cn23;

    /** @var string */
    public $parcelNumber;

    /**
     * @param mixed $responseHeader
     * @param mixed $responseBody
     * @return mixed
     * @throws Exception
     */
    public static function buildFromResponse($responseHeader, $responseBody)
    {
        $jsonResponseParser = new ColissimoResponseParser();
        try {
            $parsedResponse = $jsonResponseParser->parseBody($responseBody);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        $generateLabelResponse = new self();
        if (isset($parsedResponse['<jsonInfos>'])) {
            $generateLabelResponse->response = json_decode($parsedResponse['<jsonInfos>'], true);
            $generateLabelResponse->messages = $generateLabelResponse->response['messages'];
        }
        if (isset($generateLabelResponse->response['labelV2Response']['parcelNumber'])) {
            $generateLabelResponse->parcelNumber = $generateLabelResponse->response['labelV2Response']['parcelNumber'];
        }
        if (isset($parsedResponse['<label>'])) {
            $generateLabelResponse->label = base64_encode($parsedResponse['<label>']);
        }
        if (isset($generateLabelResponse->response['tokenV2Response']['parcelNumber'])) {
            $generateLabelResponse->parcelNumber = $generateLabelResponse->response['tokenV2Response']['parcelNumber'];
        }
        if (isset($parsedResponse['<cn23>'])) {
            $generateLabelResponse->cn23 = base64_encode($parsedResponse['<cn23>']);
        }

        return $generateLabelResponse;
    }
}
