<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class ColissimoWidgetAuthenticationRequest
 */
class ColissimoWidgetAuthenticationRequest extends AbstractColissimoRequest
{
    const WS_TYPE = 'CURL';
    const WS_PATH = '/widget-colissimo/rest/authenticate.rest';
    const WS_CONTENT_TYPE = 'application/json';

    /**
     * ColissimoWidgetAuthenticationRequest constructor.
     * @param array $credentials
     * @throws Exception
     */
    public function __construct(array $credentials)
    {
        parent::__construct($credentials);
        if (isset($this->request['contractNumber'])) {
            $this->request['login'] = $this->request['contractNumber'];
            $this->request['partnerClientCode'] = $this->request['partnerCode'];
            unset($this->request['contractNumber']);
            unset($this->request['partnerCode']);
        }
    }

    /**
     * @return void
     */
    public function buildRequest()
    {
        return;
    }

    /**
     * @param bool $obfuscatePassword
     * @return array|string
     */
    public function getRequest($obfuscatePassword = false)
    {
        if ($obfuscatePassword) {
            $request = $this->request;
            $request['password'] = '****';

            return json_encode($request);
        }

        return json_encode($this->request);
    }

    /**
     * @param mixed $responseHeader
     * @param mixed $responseBody
     * @return mixed
     * @throws Exception
     */
    public function buildResponse($responseHeader, $responseBody)
    {
        return ColissimoWidgetAuthenticationResponse::buildFromResponse($responseHeader, $responseBody);
    }
}
