<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class ColissimoSignatureInformationsRequest
 */
class ColissimoSignatureInformationsRequest extends AbstractColissimoRequest
{
    const WS_TYPE = 'CURL';
    const WS_PATH = '/v1/rest/additionalinformations';
    const WS_CONTENT_TYPE = 'application/json';

    /**
     * ColissimoSignatureInformationsRequest constructor.
     * @param array $credentials
     * @throws Exception
     */
    public function __construct(array $credentials)
    {
        parent::__construct($credentials);
        $this->request['credential']['login'] = $this->request['contractNumber'];
        $this->request['credential']['password'] = $this->request['password'];
        unset($this->request['contractNumber']);
        unset($this->request['password']);
    }

    /**
     * @return void
     */
    public function buildRequest()
    {
        return;
    }

    /**
     * @param mixed $responseHeader
     * @param mixed $responseBody
     * @return mixed
     * @throws Exception
     */
    public function buildResponse($responseHeader, $responseBody)
    {
        return ColissimoSignatureInformationsResponse::buildFromResponse($responseHeader, $responseBody);
    }
}
