<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class AbstractColissimoRequest
 */
abstract class AbstractColissimoRequest
{
    /** @var array */
    protected $request;

    /** @var string */
    protected $xmlLocation;

    /** @var string */
    public $forceEndpoint;

    /**
     * @param mixed $responseHeader
     * @param mixed $responseBody
     * @return mixed
     */
    abstract public function buildResponse($responseHeader, $responseBody);

    /**
     * @return mixed
     */
    abstract public function buildRequest();

    /**
     * AbstractColissimoRequest constructor.
     * @param array $credentials
     * @throws Exception
     */
    public function __construct(array $credentials)
    {
        if (Configuration::get('COLISSIMO_CONNEXION_KEY')) {
            if (!isset($credentials['key'])) {
                throw new Exception('Bad credentials.');
            }
        } else {
            if (!isset($credentials['contract_number']) || !isset($credentials['password'])) {
                throw new Exception('Bad credentials.');
            }
        }
        $this->setIdentification($credentials);
        $this->xmlLocation = dirname(__FILE__).'/../xml/';
    }

    /**
     * @param array $credentials
     */
    private function setIdentification(array $credentials)
    {
        $this->request = [];
        if (Configuration::get('COLISSIMO_CONNEXION_KEY')) {
            $this->request['apikey'] = $credentials['key'];
        } else {
            $this->request['contractNumber'] = $credentials['contract_number'];
            $this->request['password'] = $credentials['password'];
            $this->request['partnerCode'] = $credentials['partner_code'];
        }
        if (isset($credentials['force_endpoint'])) {
            $this->forceEndpoint = $credentials['force_endpoint'];
        }
    }

    /**
     * @param bool $obfuscatePassword
     * @return array|string
     */
    public function getRequest($obfuscatePassword = false)
    {
        if ($obfuscatePassword) {
            $request = $this->request;
            $request['password'] = '*****';
            $request['contractNumber'] = '*****';

            return json_encode($request);
        }

        return json_encode($this->request);
    }
}
